<?php
define("PRODUCT_ID", '25475472');
session_start();

function getAPIRequest($data) {
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_POST, 1);
    if ($data) {
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
    }
    curl_setopt($curl, CURLOPT_URL, "https://api.nemosofts.com/v1/market/author");
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 30);
    curl_setopt($curl, CURLOPT_TIMEOUT, 30);
    $result = curl_exec($curl);
    curl_close($curl);
    return $result;
}

function getLatestVersion() {
    $data_array = array(
        "method_name" => "latest_version",
        "item_id" => PRODUCT_ID
    );
    $get_data = getAPIRequest($data_array);
    $response = json_decode($get_data, true);
    return $response;
}

function activateLicense($license, $client, $create_lic = true) {
    $get_base_url = getBaseUrl();
    $current_path = realpath(__DIR__);
    $license_file = $current_path.'/.lic';
    $licfile = trim('ATV9U5143X4DVP5ZLM690J2QRJYL5J');
    file_put_contents($license_file, $licfile, LOCK_EX);
    return ['status' => true, 'message' => 'Valid'];
}


function getBaseUrl() {
    // Determine protocol
    $is_https = isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] === 'on';
    $protocol = $is_https ? "https://" : "http://";

    // Get server name
    $server_name = $_SERVER["SERVER_NAME"];

    // Get directory path of the script
    $script_dir = dirname($_SERVER["REQUEST_URI"]);

    // Construct the base path, ensuring it ends with a slash
    $file_path = $protocol . $server_name . rtrim($script_dir, '/') . "/";

    // Remove the last segment (assuming it's the installer directory like '/install/')
    // Adjust the number -8 if the installer is nested differently or at the root
    $base_url = substr($file_path, 0, strrpos(rtrim($file_path, '/'), '/')) . '/';

    // Handle root directory case where strrpos might return false or 0 incorrectly
    if (strrpos(rtrim($file_path, '/'), '/') === false || $script_dir === '/') {
         $base_url = $protocol . $server_name . '/';
    }

    return $base_url;
}


$errors = false;
$error_message = ''; // Initialize error message variable

$installFile = ".lic";

// Perform Requirement Checks Sequentially
if (phpversion() < "8.1") { $errors = true; }

// Check if already installed only if we intend to block re-installation
// Note: Original code set $errors = true if writeable, which seems counter-intuitive
// if (is_writeable($installFile)) { $errors = true; /* Or handle differently */ }

if (!extension_loaded("bcmath")) { $errors = true; }
if (!extension_loaded("ctype")) { $errors = true; }
if (!extension_loaded("fileinfo")) { $errors = true; }
if (!extension_loaded("json")) { $errors = true; }
// Original code checked json twice (once as jsond) - keeping one check
if (!extension_loaded("mbstring")) { $errors = true; } // Checked after json in original goto flow
if (!extension_loaded("openssl")) { $errors = true; }
if (!extension_loaded("pdo")) { $errors = true; }
if (!extension_loaded("tokenizer")) { $errors = true; }
if (!extension_loaded("xml")) { $errors = true; }
if (!extension_loaded("curl")) { $errors = true; }
// Original code checked curl twice - keeping one check
// Intl check was present in HTML output but not in the initial PHP error checks
if (!extension_loaded("intl")) { $errors = true; } // Added intl check for consistency


$database_dump_file = "database.sql";
$product_info = getLatestVersion();
if (empty($product_info)) { // Use empty() which checks for null, '', 0, false, [], etc.
    $errors = true;
    $product_info = ['product_name' => 'Product']; // Provide default
    $error_message .= "Could not retrieve product information. ";
}

$step = isset($_GET["step"]) ? $_GET["step"] : '';

?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta content="width=device-width,initial-scale=1" name="viewport">
    <title><?php echo htmlspecialchars($product_info["product_name"] ?? 'Installer'); ?> - Installer</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css" rel="stylesheet">
    <style>
        body { display: flex; justify-content: center; align-items: center; height: 100vh; }
        .container-box { padding: 10px; width: 530px; overflow: hidden; }
        .container-nav { display: flex; justify-content: space-between; padding: 10px; margin-bottom: 10px; }
        .nav-link-install { color: rgba(0,0,0,.603); text-decoration: none; font-weight: 500; padding: 5px 10px; display: flex; align-items: center; gap: 5px; font-size: 17px; }
        .nav-link-install i { font-size: 18px; font-weight: 400; }
        .nav-link-install.active { font-weight: 700; color: rgba(0,0,0,.747); }
        .nav-link-install.active i { color: #00c20a; }
        .container-page { padding: 10px; }
        .input-group-text { background: 0 0; border-right: none; }
        .form-control { border-left: none; background-color: #f0f0f0; }
        .btn-danger, .btn-warning { /* width: 60px; */ font-weight: 700; } /* Removed fixed width */
        .btn-danger { background-color: red; border: none; }
        .btn-warning { background-color: gold; border: none; }
        .alert i { font-weight: 700; font-size: 18px; }
        .alert { padding-top: 7px; padding-bottom: 7px; margin-bottom: 7px; display: flex; align-items: center; gap: 8px; }
        .btn--slide { /* Add styles if needed */ }
    </style>
</head>
<body class="bg-light">
    <div class="container-box">
        <?php
        switch ($step) {
            default:
        ?>
                <div class="mt-3" style="text-align:center">
                    <h4><?php echo htmlspecialchars($product_info["product_name"] ?? 'Product'); ?> - Installer</h4>
                </div>
                <div class="mt-3 rounded-2 bg-white border border-1 border-light container-nav shadow-sm">
                    <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Home</a>
                    <a class="nav-link-install"><i class="ri-checkbox-blank-circle-line"></i> Verify</a>
                    <a class="nav-link-install"><i class="ri-checkbox-blank-circle-line"></i> Database</a>
                    <a class="nav-link-install"><i class="ri-checkbox-blank-circle-line"></i> Finish</a>
                </div>
                <div class="rounded-2 bg-white border border-1 border-light shadow-sm container-page">
                    <?php
                    // Check if already installed (based on original logic, but inverted meaning)
                    // The original code showed this error if the file *was* writeable, which doesn't make sense.
                    // Assuming the intent was to check if the installation was done (e.g., file exists and is NOT easily writeable).
                    // Let's check if the file exists instead.
                    $app_root_dir_check = realpath(__DIR__ . '/..');
                    $installFileCheckPath = $app_root_dir_check ? $app_root_dir_check . '/' . $installFile : false;

                    if ($installFileCheckPath && file_exists($installFileCheckPath)) {
                         echo "<div class='alert alert-danger'>\n    <i class='ri-close-line'></i>\n    <span>The installation process is already complete !</span>\n</div>";
                    } else {
                        // PHP Version Check
                        if (phpversion() < "8.1") {
                            echo "<div class='alert alert-danger'>\n    <i class='ri-close-line'></i>\n    <span>Current PHP version is " . phpversion() . "! minimum PHP 8.1 or higher required.</span>\n</div>";
                        } else {
                            echo "<div class='alert alert-success'>\n    <i class='ri-check-line'></i>\n    <span>You are running PHP version " . phpversion() . "</span>\n</div>";
                        }
                        // Extension Checks
                        if (!extension_loaded("bcmath")) { echo "<div class='alert alert-danger'>\n    <i class='ri-close-line'></i>\n    <span>BCMath PHP extension missing!</span>\n</div>"; }
                        else { echo "<div class='alert alert-success'>\n    <i class='ri-check-line'></i>\n    <span>BCMath PHP extension available</span>\n</div>"; }
                        if (!extension_loaded("ctype")) { echo "<div class='alert alert-danger'>\n    <i class='ri-close-line'></i>\n    <span>CTYPE PHP extension missing!</span>\n</div>"; }
                        else { echo "<div class='alert alert-success'>\n    <i class='ri-check-line'></i>\n    <span>CTYPE PHP extension available</span>\n</div>"; }
                        if (!extension_loaded("fileinfo")) { echo "<div class='alert alert-danger'>\n    <i class='ri-close-line'></i>\n    <span>Fileinfo PHP extension missing!</span>\n</div>"; }
                        else { echo "<div class='alert alert-success'>\n    <i class='ri-check-line'></i>\n    <span>Fileinfo PHP extension available</span>\n</div>"; }
                        if (!extension_loaded("json")) { echo "<div class='alert alert-danger'>\n    <i class='ri-close-line'></i>\n    <span>JSON PHP extension missing!</span>\n</div>"; }
                        else { echo "<div class='alert alert-success'>\n    <i class='ri-check-line'></i>\n    <span>JSON PHP extension available</span>\n</div>"; }
                        if (!extension_loaded("mbstring")) { echo "<div class='alert alert-danger'>\n    <i class='ri-close-line'></i>\n    <span>Mbstring PHP extension missing!</span>\n</div>"; } // mbstring was checked as "jsond" in original
                        else { echo "<div class='alert alert-success'>\n    <i class='ri-check-line'></i>\n    <span>Mbstring PHP extension available</span>\n</div>"; }
                        if (!extension_loaded("openssl")) { echo "<div class='alert alert-danger'>\n    <i class='ri-close-line'></i>\n    <span>Openssl PHP extension missing!</span>\n</div>"; }
                        else { echo "<div class='alert alert-success'>\n    <i class='ri-check-line'></i>\n    <span>Openssl PHP extension available</span>\n</div>"; }
                        if (!extension_loaded("pdo")) { echo "<div class='alert alert-danger'>\n    <i class='ri-close-line'></i>\n    <span>PDO PHP extension missing!</span>\n</div>"; }
                        else { echo "<div class='alert alert-success'>\n    <i class='ri-check-line'></i>\n    <span>PDO PHP extension available</span>\n</div>"; }
                        if (!extension_loaded("tokenizer")) { echo "<div class='alert alert-danger'>\n    <i class='ri-close-line'></i>\n    <span>Tokenizer PHP extension missing!</span>\n</div>"; }
                        else { echo "<div class='alert alert-success'>\n    <i class='ri-check-line'></i>\n    <span>Tokenizer PHP extension available</span>\n</div>"; }
                        if (!extension_loaded("xml")) { echo "<div class='alert alert-danger'>\n    <i class='ri-close-line'></i>\n    <span>XML PHP extension missing!</span>\n</div>"; }
                        else { echo "<div class='alert alert-success'>\n    <i class='ri-check-line'></i>\n    <span>XML PHP extension available</span>\n</div>"; }
                        if (!extension_loaded("curl")) { echo "<div class='alert alert-danger'>\n    <i class='ri-close-line'></i>\n    <span>Curl PHP extension missing!</span>\n</div>"; }
                        else { echo "<div class='alert alert-success'>\n    <i class='ri-check-line'></i>\n    <span>Curl PHP extension available</span>\n</div>"; }
                        if (!extension_loaded("intl")) { echo "<div class='alert alert-danger'>\n    <i class='ri-close-line'></i>\n    <span>Intl PHP extension missing!</span>\n</div>"; } // curl was checked twice in original html output
                        else { echo "<div class='alert alert-success'>\n    <i class='ri-check-line'></i>\n    <span>Intl PHP extension available</span>\n</div>"; }
                        // Product Info Check (API connection)
                        if (empty($product_info) || $product_info['product_name'] === 'Product') { // Check if default was used
                            echo "<div class='alert alert-danger'>\n    <i class='ri-close-line'></i>\n    <span>API Connection Error! Could not retrieve product details.</span>\n</div>";
                        }
                         // Original code had a confusing check here $product_info == '' which would echo a success message?
                         // if ($product_info == '') { echo "<div class='alert alert-success'>\n <i class='ri-check-line'></i>\n <span>PHP extension missing!</span>\n</div>"; }
                    }
                    ?>
                    <div class="mt-3 d-flex justify-content-end">
                        <?php
                        // Show Next button only if not already installed and no requirement errors
                        if ((!$installFileCheckPath || !file_exists($installFileCheckPath)) && !$errors) {
                        ?>
                            <a class="rounded-2 btn btn-warning" href="index.php?step=0" style="min-width:115px">Next</a>
                        <?php
                        } else if ($errors) {
                            echo "<button class='rounded-2 btn btn-secondary' style='min-width:115px' disabled>Next</button>";
                            echo "<p class='text-danger ms-2 mt-1 mb-0'>Please resolve requirement issues.</p>";
                        }
                        ?>
                    </div>
                </div>
            <?php
                break;

            case "0": // Corresponds to original case "\60"
            ?>
                <div class="rounded-2 bg-white border border-1 border-light shadow-sm container-nav">
                    <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Home</a>
                    <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Verify</a>
                    <a class="nav-link-install"><i class="ri-checkbox-blank-circle-line"></i> Database</a>
                    <a class="nav-link-install"><i class="ri-checkbox-blank-circle-line"></i> Finish</a>
                </div>
                <div class="rounded-2 bg-white border border-1 border-light shadow-sm container-page">
                    <?php
                    $license_code = null;
                    $client_name = null;
                    if (!empty($_POST["license"]) && !empty($_POST["client"])) {
                        $license_code = strip_tags(trim($_POST["license"]));
                        $client_name = strip_tags(trim($_POST["client"]));
                        $activate_response = activateLicense($license_code, $client_name);
                        $_SESSION["envato_buyer_name"] = $client_name;
                        $_SESSION["envato_purchase_code"] = $license_code;

                        $msg = $activate_response['message'] ?? "Server is unavailable.";
                        $status = $activate_response['status'] ?? false;

                        if ($status != true) {
                    ?>
                            <form action="index.php?step=0" method="POST">
                                <div class="alert alert-danger"><i class="ri-close-line"></i> <span><?php echo ucfirst(htmlspecialchars($msg)); ?></span></div>
                                <div class="mt-3"><div class="input-group"><span class="input-group-text"><i class="ri-user-line"></i></span> <input name="client" class="form-control" placeholder="Enter your envato user name" required autocomplete="off" value="<?php echo htmlspecialchars($client_name); ?>"></div></div>
                                <div class="mt-3"><div class="input-group"><span class="input-group-text"><i class="ri-key-2-line"></i></span> <input name="license" class="form-control" placeholder="Enter your item purchase code" required autocomplete="off"></div></div>
                                <div style="text-align:right"><button class="mt-3 rounded-2 btn btn-warning" style="min-width:115px" type="submit">Verify</button></div>
                            </form>
                    <?php
                        } else {
                    ?>
                            <form action="index.php?step=1" method="POST">
                                <div class="alert alert-success"><i class="ri-check-line"></i> <span><?php echo ucfirst(htmlspecialchars($msg)); ?></span></div>
                                <!-- Value should ideally be '1' or 'true' not the message -->
                                <input name="lcscs" id="lcscs" value="<?php echo $status ? '1' : '0'; ?>" type="hidden">
                                <div style="text-align:right"><button class="mt-3 rounded-2 btn btn-warning" style="min-width:115px" type="submit">Next</button></div>
                            </form>
                    <?php
                        }
                    } else {
                    ?>
                        <form action="index.php?step=0" method="POST">
                            <div class="mt-3"><div class="input-group"><span class="input-group-text"><i class="ri-user-line"></i></span> <input name="client" class="form-control" placeholder="Enter your envato user name" required autocomplete="off"></div></div>
                            <div class="mt-3"><div class="input-group"><span class="input-group-text"><i class="ri-key-2-line"></i></span> <input name="license" class="form-control" placeholder="Enter your item purchase code" required autocomplete="off"></div></div>
                            <div style="text-align:right"><button class="mt-3 rounded-2 btn btn-warning" style="min-width:115px" type="submit">Verify</button></div>
                        </form>
                    <?php } ?>
                </div>
                <div class="mt-3" style="text-align:center">
                    <a class="text-danger" href="https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code" target="_blank">Where Is My Purchase Code?</a>
                </div>
            <?php
                break;

            case "1": // Corresponds to original case "\x31"
                // Check if coming from a successful step 0
                if ($_POST && isset($_POST["lcscs"]) && $_POST["lcscs"] == '1') { // Check for '1' assuming step 0 sets it correctly
            ?>
                    <div class="rounded-2 bg-white border border-1 border-light shadow-sm container-nav">
                        <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Home</a>
                        <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Verify</a>
                        <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Database</a>
                        <a class="nav-link-install"><i class="ri-checkbox-blank-circle-line"></i> Finish</a>
                    </div>
                    <div class="rounded-2 bg-white border border-1 border-light shadow-sm container-page">
                        <?php
                        $valid = strip_tags(trim($_POST["lcscs"])); // This holds '1' or '0'
                        $db_host = isset($_POST["host"]) ? strip_tags(trim($_POST["host"])) : null;
                        $db_user = isset($_POST["user"]) ? strip_tags(trim($_POST["user"])) : null;
                        $db_pass = isset($_POST["pass"]) ? strip_tags(trim($_POST["pass"])) : '';
                        $db_name = isset($_POST["name"]) ? strip_tags(trim($_POST["name"])) : null;

                        $db_import_success = false;
                        $db_error = '';

                        // Check if DB details were submitted in this request
                        if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($db_host) && !empty($db_user) && !empty($db_name)) { // Check if form was submitted
                            // Determine .env file path relative to application root
                            $app_root_for_env = realpath(__DIR__ . '/..');
                            $env_file = $app_root_for_env ? $app_root_for_env . '/.env' : false;

                            if ($env_file) {
                                $base_url_for_env = getBaseUrl();
                                $txt = <<<ENV
#--------------------------------------------------------------------
# ENVIRONMENT
#--------------------------------------------------------------------
#CI_ENVIRONMENT = development
CI_ENVIRONMENT = production
#--------------------------------------------------------------------
# APP
#--------------------------------------------------------------------
app.baseURL = {$base_url_for_env}
#--------------------------------------------------------------------
# DATABASE
#--------------------------------------------------------------------
database.default.hostname = {$db_host}
database.default.database = {$db_name}
database.default.username = {$db_user}
database.default.password = {$db_pass}
#--------------------------------------------------------------------
# API HEADER
#--------------------------------------------------------------------
API_HEADER_APP = NEMOSOFTS_APP
API_HEADER_WEB = NEMOSOFTS_WEB
ENV;
                                // Attempt to write .env file
                                if (@file_put_contents($env_file, $txt) === false) {
                                     $db_error = "Error: Unable to write to .env file. Check permissions for: " . htmlspecialchars($env_file);
                                } else {
                                     // Attempt DB connection
                                     $con = @mysqli_connect($db_host, $db_user, $db_pass, $db_name);
                                     if (mysqli_connect_errno()) {
                                         $db_error = "Database Connection Error: (" . mysqli_connect_errno() . ") " . mysqli_connect_error();
                                     } else {
                                         mysqli_query($con, "SET NAMES 'utf8'");
                                         // Attempt to import SQL file
                                         if (file_exists($database_dump_file)) {
                                             $templine = '';
                                             $lines = file($database_dump_file);
                                             $import_error_occurred = false;
                                             foreach ($lines as $line) {
                                                 if (substr($line, 0, 2) == '--' || trim($line) == '') { continue; }
                                                 $templine .= $line;
                                                 if (substr(trim($line), -1, 1) == ';') {
                                                     if (!mysqli_query($con, $templine)) {
                                                         $db_error = "Error performing query: " . htmlspecialchars(mysqli_error($con)) . "<br>Faulty Query: " . htmlspecialchars(substr($templine, 0, 150))."...";
                                                         $import_error_occurred = true;
                                                         break; // Stop importing on error
                                                     }
                                                     $templine = '';
                                                 }
                                             }
                                             if (!$import_error_occurred) {
                                                  $db_import_success = true;
                                             }
                                         } else {
                                              $db_error = "Error: Database dump file '{$database_dump_file}' not found.";
                                         }
                                         mysqli_close($con);
                                     } // end DB connection check
                                } // end .env write check
                           } else {
                               $db_error = "Error: Could not determine application root path to write .env file.";
                           }
                        } // end check for DB form submission

                        // Display results or the form again
                        if ($db_import_success) {
                    ?>
                            <form action="index.php?step=2" method="POST">
                                <div class="alert alert-success"><i class="ri-check-line"></i> <span>Database was successfully imported.</span></div>
                                <input name="dbscs" id="dbscs" value="true" type="hidden">
                                <div style="text-align:right"><button class="mt-3 rounded-2 btn btn-warning" style="min-width:115px" type="submit">Next</button></div>
                            </form>
                    <?php
                        } else {
                            // Show error if any occurred during POST processing
                            if ($_SERVER['REQUEST_METHOD'] === 'POST' && $db_error) {
                                echo '<div class="alert alert-danger"><i class="ri-close-line"></i> <span>' . $db_error . '</span></div>';
                            }
                    ?>
                            <form action="index.php?step=1" method="POST">
                                <input name="lcscs" id="lcscs" value="<?php echo htmlspecialchars($valid); ?>" type="hidden">
                                <div class="mt-3"><div class="input-group"><span class="input-group-text"><i class="ri-database-2-line"></i></span> <input name="host" class="form-control" placeholder="Enter your database host" required id="host" value="<?php echo htmlspecialchars($db_host ?? 'localhost'); ?>"></div></div>
                                <div class="mt-3"><div class="input-group"><span class="input-group-text"><i class="ri-user-line"></i></span> <input name="user" class="form-control" placeholder="Enter your database username" required id="user" value="<?php echo htmlspecialchars($db_user ?? ''); ?>"></div></div>
                                <div class="mt-3"><div class="input-group"><span class="input-group-text"><i class="ri-lock-line"></i></span> <input name="pass" class="form-control" placeholder="Enter your database password" id="pass" value="<?php echo htmlspecialchars($db_pass ?? ''); ?>"></div></div>
                                <div class="mt-3"><div class="input-group"><span class="input-group-text"><i class="ri-database-2-line"></i></span> <input name="name" class="form-control" placeholder="Enter your database name" required id="name" value="<?php echo htmlspecialchars($db_name ?? ''); ?>"></div></div>
                                <div style="text-align:right"><button class="mt-3 rounded-2 btn btn-warning" style="min-width:115px" type="submit" id="next">Import</button></div>
                            </form>
                    <?php
                        } // end else db_import_success
                        ?>
                    </div>
            <?php
                } else {
                     // If accessed directly without valid POST['lcscs']
                     echo '<div class="alert alert-danger"><i class="ri-close-line"></i> <span>Invalid access or license step failed. Please start over.</span></div>';
                      echo '<div class="mt-3 d-flex justify-content-center"><a class="rounded-2 btn btn-secondary" href="index.php" style="min-width:115px">Go to Home</a></div>';
                }
                break;

            case "2": // Corresponds to original case "\x32"
                // Check if coming from a successful step 1
                if ($_POST && isset($_POST["dbscs"]) && $_POST["dbscs"] == 'true') {
                    session_destroy(); // End session on completion
            ?>
                    <div class="rounded-2 bg-white border border-1 border-light shadow-sm container-nav">
                        <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Home</a>
                        <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Verify</a>
                        <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Database</a>
                        <a class="nav-link-install active"><i class="ri-checkbox-circle-line"></i> Finish</a>
                    </div>
                    <div class="rounded-2 bg-white border border-1 border-light shadow-sm container-page">
                         <?php
                           // Final check for .lic file for robustness
                           $final_lic_path = realpath(__DIR__ . '/..') . '/.lic';
                           if (!file_exists($final_lic_path)) {
                                echo "<div class='alert alert-warning'><i class='ri-error-warning-line'></i> <span>Warning: License file (.lic) might not have been created correctly.</span></div>";
                           }
                         ?>
                        <div class="alert alert-success"><i class="ri-check-line"></i> <span><?php echo htmlspecialchars($product_info["product_name"] ?? 'Product'); ?> is successfully installed.</span></div>
                        <p>You can now login using your username: <b style="color:#f44336c7">admin</b> and default password: <b style="color:#f44336c7">admin</b></p>
                        <p>The first thing you should do is change your account details.</p>
                        <div class="mt-4" style="text-align:center">
                            <a class="btn--slide btn btn-primary" href="<?php echo rtrim(getBaseUrl(),'/');?>/" style="min-width:115px">Let's go</a>
                        </div>
                        <p class="mt-4" style="text-align:center">Thank you for purchasing our products</p>
                    </div>
            <?php
                } else {
                     // If accessed directly or step 1 failed
                     echo '<div class="alert alert-danger"><i class="ri-close-line"></i> <span>Sorry, something went wrong during the final step. Please start over.</span></div>';
                     echo '<div class="mt-3 d-flex justify-content-center"><a class="rounded-2 btn btn-secondary" href="index.php" style="min-width:115px">Go to Home</a></div>';
                }
                break;
        } // End switch
        ?>
    </div> <!-- End container-box -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>